/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import reactor.core.publisher.CallSiteSupplierFactory;

final class Traces {
    static final boolean full = Boolean.parseBoolean(System.getProperty("reactor.trace.assembly.fullstacktrace", "false"));
    static final String CALL_SITE_GLUE = " \u21e2 ";
    static final Supplier<Supplier<String>> callSiteSupplierFactory = new CallSiteSupplierFactory();
    private static final String PUBLISHER_PACKAGE_PREFIX = "reactor.core.publisher.";

    Traces() {
    }

    static boolean shouldSanitize(String stackTraceRow) {
        return stackTraceRow.startsWith("java.util.function") || stackTraceRow.startsWith("reactor.core.publisher.Mono.onAssembly") || stackTraceRow.startsWith("reactor.core.publisher.Flux.onAssembly") || stackTraceRow.startsWith("reactor.core.publisher.ParallelFlux.onAssembly") || stackTraceRow.startsWith("reactor.core.publisher.SignalLogger") || stackTraceRow.startsWith("reactor.core.publisher.FluxOnAssembly") || stackTraceRow.startsWith("reactor.core.publisher.MonoOnAssembly.") || stackTraceRow.startsWith("reactor.core.publisher.MonoCallableOnAssembly.") || stackTraceRow.startsWith("reactor.core.publisher.FluxCallableOnAssembly.") || stackTraceRow.startsWith("reactor.core.publisher.Hooks") || stackTraceRow.startsWith("sun.reflect") || stackTraceRow.startsWith("java.util.concurrent.ThreadPoolExecutor") || stackTraceRow.startsWith("java.lang.reflect");
    }

    static String extractOperatorAssemblyInformation(String source) {
        String[] parts = Traces.extractOperatorAssemblyInformationParts(source);
        switch (parts.length) {
            case 0: {
                return "[no operator assembly information]";
            }
            case 1: {
                return parts[0];
            }
            case 2: {
                return parts[0] + CALL_SITE_GLUE + parts[1];
            }
        }
        throw new IllegalStateException("Unexpected number of assembly info parts: " + parts.length);
    }

    static boolean isUserCode(String line) {
        return !line.startsWith(PUBLISHER_PACKAGE_PREFIX) || line.contains("Test");
    }

    static String[] extractOperatorAssemblyInformationParts(String source) {
        Iterator<StackLineView> traces = Traces.trimmedNonemptyLines(source);
        if (!traces.hasNext()) {
            return new String[0];
        }
        StackLineView prevLine = null;
        StackLineView currentLine = traces.next();
        if (currentLine.isUserCode()) {
            return new String[]{currentLine.toString()};
        }
        while (traces.hasNext()) {
            prevLine = currentLine;
            currentLine = traces.next();
            if (!currentLine.isUserCode()) continue;
            return new String[]{prevLine.withoutPublisherPackagePrefix().withoutLocationSuffix().toString(), "at " + currentLine};
        }
        return new String[]{currentLine.withoutPublisherPackagePrefix().toString()};
    }

    private static Iterator<StackLineView> trimmedNonemptyLines(final String source) {
        return new Iterator<StackLineView>(){
            private int index = 0;
            private @Nullable StackLineView next = this.getNextLine();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public StackLineView next() {
                StackLineView current = this.next;
                if (current == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.getNextLine();
                return current;
            }

            private @Nullable StackLineView getNextLine() {
                while (this.index < source.length()) {
                    int end = source.indexOf(10, this.index);
                    if (end == -1) {
                        end = source.length();
                    }
                    StackLineView line = new StackLineView(source, this.index, end).trim();
                    this.index = end + 1;
                    if (line.isEmpty()) continue;
                    return line;
                }
                return null;
            }
        };
    }

    static final class StackLineView {
        private final String underlying;
        private final int start;
        private final int end;

        StackLineView(String underlying, int start, int end) {
            this.underlying = underlying;
            this.start = start;
            this.end = end;
        }

        StackLineView trim() {
            int newEnd;
            int newStart;
            for (newStart = this.start; newStart < this.end && this.underlying.charAt(newStart) <= ' '; ++newStart) {
            }
            for (newEnd = this.end; newEnd > newStart && this.underlying.charAt(newEnd - 1) <= ' '; --newEnd) {
            }
            return newStart == this.start && newEnd == this.end ? this : new StackLineView(this.underlying, newStart, newEnd);
        }

        boolean isEmpty() {
            return this.start == this.end;
        }

        boolean startsWith(String prefix) {
            boolean canFit = this.end - this.start >= prefix.length();
            return canFit && this.underlying.startsWith(prefix, this.start);
        }

        boolean contains(String substring) {
            int index = this.underlying.indexOf(substring, this.start);
            return index >= this.start && index + (substring.length() - 1) < this.end;
        }

        boolean isUserCode() {
            return !this.startsWith(Traces.PUBLISHER_PACKAGE_PREFIX) || this.contains("Test");
        }

        StackLineView withoutLocationSuffix() {
            int linePartIndex = this.underlying.indexOf(40, this.start);
            return linePartIndex > 0 && linePartIndex < this.end ? new StackLineView(this.underlying, this.start, linePartIndex) : this;
        }

        StackLineView withoutPublisherPackagePrefix() {
            return this.startsWith(Traces.PUBLISHER_PACKAGE_PREFIX) ? new StackLineView(this.underlying, this.start + Traces.PUBLISHER_PACKAGE_PREFIX.length(), this.end) : this;
        }

        public String toString() {
            return this.underlying.substring(this.start, this.end);
        }
    }
}

