/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;

public class DataUtil {
    public static double[][] ltrim(double[][] arr) {
        int numRows = arr.length;
        if (numRows == 0) {
            return new double[0][0];
        }
        int numCols = arr[0].length;
        int startIndex = numRows;
        for (int i = 0; i < numRows; ++i) {
            boolean hasNaN = false;
            for (int j = 0; j < numCols; ++j) {
                if (!Double.isNaN(arr[i][j])) continue;
                hasNaN = true;
                break;
            }
            if (hasNaN) continue;
            startIndex = i;
            break;
        }
        return (double[][])Arrays.copyOfRange(arr, startIndex, arr.length);
    }

    public static int[] generateMissingIndicesArray(double[] point) {
        ArrayList<Integer> intArray = new ArrayList<Integer>();
        for (int i = 0; i < point.length; ++i) {
            if (!Double.isNaN(point[i])) continue;
            intArray.add(i);
        }
        if (intArray.size() == 0) {
            return null;
        }
        return intArray.stream().mapToInt(Integer::intValue).toArray();
    }

    public static boolean areAnyElementsNaN(double[] array) {
        return Arrays.stream(array).anyMatch(Double::isNaN);
    }

    public static double roundDouble(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

