"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HIDDEN_BANNER_HEIGHT = exports.DEFAULT_BANNER_CONFIG = exports.BANNER_CONTAINER_ID = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/**
 * DOM element ID for the banner container
 */
const BANNER_CONTAINER_ID = exports.BANNER_CONTAINER_ID = 'pluginGlobalBanner';

/**
 * Height of the banner when hidden (in pixels)
 */
const HIDDEN_BANNER_HEIGHT = exports.HIDDEN_BANNER_HEIGHT = '0px';

/**
 * Default banner configuration values
 */
const DEFAULT_BANNER_CONFIG = exports.DEFAULT_BANNER_CONFIG = {
  content: 'Banner Content',
  color: 'primary',
  iconType: 'iInCircle',
  isVisible: true,
  useMarkdown: true,
  size: 'm'
};