/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.BgpStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayAttachmentBgpConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayAttachmentBgpConfiguration> {
    private static final SdkField<Long> TRANSIT_GATEWAY_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TransitGatewayAsn").getter(TransitGatewayAttachmentBgpConfiguration.getter(TransitGatewayAttachmentBgpConfiguration::transitGatewayAsn)).setter(TransitGatewayAttachmentBgpConfiguration.setter(Builder::transitGatewayAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAsn").unmarshallLocationName("transitGatewayAsn").build()}).build();
    private static final SdkField<Long> PEER_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PeerAsn").getter(TransitGatewayAttachmentBgpConfiguration.getter(TransitGatewayAttachmentBgpConfiguration::peerAsn)).setter(TransitGatewayAttachmentBgpConfiguration.setter(Builder::peerAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAsn").unmarshallLocationName("peerAsn").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAddress").getter(TransitGatewayAttachmentBgpConfiguration.getter(TransitGatewayAttachmentBgpConfiguration::transitGatewayAddress)).setter(TransitGatewayAttachmentBgpConfiguration.setter(Builder::transitGatewayAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress").unmarshallLocationName("transitGatewayAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(TransitGatewayAttachmentBgpConfiguration.getter(TransitGatewayAttachmentBgpConfiguration::peerAddress)).setter(TransitGatewayAttachmentBgpConfiguration.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<String> BGP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BgpStatus").getter(TransitGatewayAttachmentBgpConfiguration.getter(TransitGatewayAttachmentBgpConfiguration::bgpStatusAsString)).setter(TransitGatewayAttachmentBgpConfiguration.setter(Builder::bgpStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpStatus").unmarshallLocationName("bgpStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ASN_FIELD, PEER_ASN_FIELD, TRANSIT_GATEWAY_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayAttachmentBgpConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long transitGatewayAsn;
    private final Long peerAsn;
    private final String transitGatewayAddress;
    private final String peerAddress;
    private final String bgpStatus;

    private TransitGatewayAttachmentBgpConfiguration(BuilderImpl builder) {
        this.transitGatewayAsn = builder.transitGatewayAsn;
        this.peerAsn = builder.peerAsn;
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpStatus = builder.bgpStatus;
    }

    public final Long transitGatewayAsn() {
        return this.transitGatewayAsn;
    }

    public final Long peerAsn() {
        return this.peerAsn;
    }

    public final String transitGatewayAddress() {
        return this.transitGatewayAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final BgpStatus bgpStatus() {
        return BgpStatus.fromValue(this.bgpStatus);
    }

    public final String bgpStatusAsString() {
        return this.bgpStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachmentBgpConfiguration)) {
            return false;
        }
        TransitGatewayAttachmentBgpConfiguration other = (TransitGatewayAttachmentBgpConfiguration)obj;
        return Objects.equals(this.transitGatewayAsn(), other.transitGatewayAsn()) && Objects.equals(this.peerAsn(), other.peerAsn()) && Objects.equals(this.transitGatewayAddress(), other.transitGatewayAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.bgpStatusAsString(), other.bgpStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayAttachmentBgpConfiguration").add("TransitGatewayAsn", (Object)this.transitGatewayAsn()).add("PeerAsn", (Object)this.peerAsn()).add("TransitGatewayAddress", (Object)this.transitGatewayAddress()).add("PeerAddress", (Object)this.peerAddress()).add("BgpStatus", (Object)this.bgpStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAsn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAsn()));
            }
            case "PeerAsn": {
                return Optional.ofNullable(clazz.cast(this.peerAsn()));
            }
            case "TransitGatewayAddress": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "BgpStatus": {
                return Optional.ofNullable(clazz.cast(this.bgpStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayAsn", TRANSIT_GATEWAY_ASN_FIELD);
        map.put("PeerAsn", PEER_ASN_FIELD);
        map.put("TransitGatewayAddress", TRANSIT_GATEWAY_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("BgpStatus", BGP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachmentBgpConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayAttachmentBgpConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long transitGatewayAsn;
        private Long peerAsn;
        private String transitGatewayAddress;
        private String peerAddress;
        private String bgpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachmentBgpConfiguration model) {
            this.transitGatewayAsn(model.transitGatewayAsn);
            this.peerAsn(model.peerAsn);
            this.transitGatewayAddress(model.transitGatewayAddress);
            this.peerAddress(model.peerAddress);
            this.bgpStatus(model.bgpStatus);
        }

        public final Long getTransitGatewayAsn() {
            return this.transitGatewayAsn;
        }

        public final void setTransitGatewayAsn(Long transitGatewayAsn) {
            this.transitGatewayAsn = transitGatewayAsn;
        }

        @Override
        public final Builder transitGatewayAsn(Long transitGatewayAsn) {
            this.transitGatewayAsn = transitGatewayAsn;
            return this;
        }

        public final Long getPeerAsn() {
            return this.peerAsn;
        }

        public final void setPeerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
        }

        @Override
        public final Builder peerAsn(Long peerAsn) {
            this.peerAsn = peerAsn;
            return this;
        }

        public final String getTransitGatewayAddress() {
            return this.transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final String getBgpStatus() {
            return this.bgpStatus;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        @Override
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        public final Builder bgpStatus(BgpStatus bgpStatus) {
            this.bgpStatus(bgpStatus == null ? null : bgpStatus.toString());
            return this;
        }

        public TransitGatewayAttachmentBgpConfiguration build() {
            return new TransitGatewayAttachmentBgpConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayAttachmentBgpConfiguration> {
        public Builder transitGatewayAsn(Long var1);

        public Builder peerAsn(Long var1);

        public Builder transitGatewayAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder bgpStatus(String var1);

        public Builder bgpStatus(BgpStatus var1);
    }
}

