/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.algorithm.seismic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensearch.common.ValidationException;
import org.opensearch.neuralsearch.sparse.algorithm.SparseAlgorithm;
import org.opensearch.neuralsearch.sparse.mapper.SparseMethodContext;

public class Seismic
implements SparseAlgorithm {
    public static final Seismic INSTANCE = new Seismic();

    @Override
    public ValidationException validateMethod(SparseMethodContext sparseMethodContext) {
        String fieldValueString;
        String algoName = sparseMethodContext.getMethodComponentContext().getName();
        ValidationException validationException = null;
        ArrayList<String> errorMessages = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>(sparseMethodContext.getMethodComponentContext().getParameters());
        if (parameters.containsKey("summary_prune_ratio")) {
            try {
                fieldValueString = parameters.get("summary_prune_ratio").toString();
                float summaryPruneRatio = NumberUtils.createFloat((String)fieldValueString).floatValue();
                if (summaryPruneRatio <= 0.0f || summaryPruneRatio > 1.0f) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be in (0, 1]", "summary_prune_ratio"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "summary_prune_ratio", Float.class.getName()));
            }
            parameters.remove("summary_prune_ratio");
        }
        if (parameters.containsKey("n_postings")) {
            try {
                fieldValueString = parameters.get("n_postings").toString();
                int nPostings = NumberUtils.createInteger((String)fieldValueString);
                if (nPostings <= 0) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be a positive integer", "n_postings"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "n_postings", Integer.class.getName()));
            }
            parameters.remove("n_postings");
        }
        if (parameters.containsKey("cluster_ratio")) {
            try {
                fieldValueString = parameters.get("cluster_ratio").toString();
                float clusterRatio = NumberUtils.createFloat((String)fieldValueString).floatValue();
                if (clusterRatio <= 0.0f || clusterRatio >= 1.0f) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be in (0, 1)", "cluster_ratio"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "cluster_ratio", Float.class.getName()));
            }
            parameters.remove("cluster_ratio");
        }
        if (parameters.containsKey("approximate_threshold")) {
            try {
                fieldValueString = parameters.get("approximate_threshold").toString();
                int algoTriggerThreshold = NumberUtils.createInteger((String)fieldValueString);
                if (algoTriggerThreshold < 0) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be a non-negative integer", "approximate_threshold"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "approximate_threshold", Integer.class.getName()));
            }
            parameters.remove("approximate_threshold");
        }
        if (parameters.containsKey("quantization_ceiling_ingest")) {
            try {
                fieldValueString = parameters.get("quantization_ceiling_ingest").toString();
                float quantizationCeilValue = NumberUtils.createFloat((String)fieldValueString).floatValue();
                if (quantizationCeilValue <= 0.0f) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be a positive float number", "quantization_ceiling_ingest"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "quantization_ceiling_ingest", Float.class.getName()));
            }
            parameters.remove("quantization_ceiling_ingest");
        }
        if (parameters.containsKey("quantization_ceiling_search")) {
            try {
                fieldValueString = parameters.get("quantization_ceiling_search").toString();
                float quantizationCeilValue = NumberUtils.createFloat((String)fieldValueString).floatValue();
                if (quantizationCeilValue <= 0.0f) {
                    errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be a positive float number", "quantization_ceiling_search"));
                }
            }
            catch (Exception e) {
                errorMessages.add(String.format(Locale.ROOT, "Parameter [%s] must be of %s type", "quantization_ceiling_search", Float.class.getName()));
            }
            parameters.remove("quantization_ceiling_search");
        }
        for (String key : parameters.keySet()) {
            errorMessages.add(String.format(Locale.ROOT, "Unknown parameter '%s' found", key));
        }
        if (!errorMessages.isEmpty()) {
            validationException = new ValidationException();
            validationException.addValidationErrors(errorMessages);
        }
        return validationException;
    }

    @Generated
    private Seismic() {
    }
}

