/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ModelStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ModelStats> {
    @Nullable
    private final Long mlActionFailureCount;
    @Nullable
    private final Long mlActionRequestCount;
    @Nullable
    private final Long mlExecutingTaskCount;
    public static final JsonpDeserializer<ModelStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelStats::setupModelStatsDeserializer);

    private ModelStats(Builder builder) {
        this.mlActionFailureCount = builder.mlActionFailureCount;
        this.mlActionRequestCount = builder.mlActionRequestCount;
        this.mlExecutingTaskCount = builder.mlExecutingTaskCount;
    }

    public static ModelStats of(Function<Builder, ObjectBuilder<ModelStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long mlActionFailureCount() {
        return this.mlActionFailureCount;
    }

    @Nullable
    public final Long mlActionRequestCount() {
        return this.mlActionRequestCount;
    }

    @Nullable
    public final Long mlExecutingTaskCount() {
        return this.mlExecutingTaskCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.mlActionFailureCount != null) {
            generator.writeKey("ml_action_failure_count");
            generator.write(this.mlActionFailureCount.longValue());
        }
        if (this.mlActionRequestCount != null) {
            generator.writeKey("ml_action_request_count");
            generator.write(this.mlActionRequestCount.longValue());
        }
        if (this.mlExecutingTaskCount != null) {
            generator.writeKey("ml_executing_task_count");
            generator.write(this.mlExecutingTaskCount.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupModelStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mlActionFailureCount, JsonpDeserializer.longDeserializer(), "ml_action_failure_count");
        op.add(Builder::mlActionRequestCount, JsonpDeserializer.longDeserializer(), "ml_action_request_count");
        op.add(Builder::mlExecutingTaskCount, JsonpDeserializer.longDeserializer(), "ml_executing_task_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mlActionFailureCount);
        result = 31 * result + Objects.hashCode(this.mlActionRequestCount);
        result = 31 * result + Objects.hashCode(this.mlExecutingTaskCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelStats other = (ModelStats)o;
        return Objects.equals(this.mlActionFailureCount, other.mlActionFailureCount) && Objects.equals(this.mlActionRequestCount, other.mlActionRequestCount) && Objects.equals(this.mlExecutingTaskCount, other.mlExecutingTaskCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ModelStats> {
        @Nullable
        private Long mlActionFailureCount;
        @Nullable
        private Long mlActionRequestCount;
        @Nullable
        private Long mlExecutingTaskCount;

        public Builder() {
        }

        private Builder(ModelStats o) {
            this.mlActionFailureCount = o.mlActionFailureCount;
            this.mlActionRequestCount = o.mlActionRequestCount;
            this.mlExecutingTaskCount = o.mlExecutingTaskCount;
        }

        private Builder(Builder o) {
            this.mlActionFailureCount = o.mlActionFailureCount;
            this.mlActionRequestCount = o.mlActionRequestCount;
            this.mlExecutingTaskCount = o.mlExecutingTaskCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder mlActionFailureCount(@Nullable Long value) {
            this.mlActionFailureCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlActionRequestCount(@Nullable Long value) {
            this.mlActionRequestCount = value;
            return this;
        }

        @Nonnull
        public final Builder mlExecutingTaskCount(@Nullable Long value) {
            this.mlExecutingTaskCount = value;
            return this;
        }

        @Override
        @Nonnull
        public ModelStats build() {
            this._checkSingleUse();
            return new ModelStats(this);
        }
    }
}

