/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.Collection;
import java.util.LinkedList;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.junit.StubbingHint;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Stubbing;

public class UnusedStubbings {
    private final Collection<? extends Stubbing> unused;

    UnusedStubbings(Collection<? extends Stubbing> unused) {
        this.unused = unused;
    }

    void format(String testName, MockitoLogger logger) {
        if (this.unused.isEmpty()) {
            return;
        }
        StubbingHint hint = new StubbingHint(testName);
        int x = 1;
        for (Stubbing stubbing : this.unused) {
            if (stubbing.wasUsed()) continue;
            hint.appendLine(x++, ". Unused ", stubbing.getInvocation().getLocation());
        }
        logger.log(hint.toString());
    }

    public int size() {
        return this.unused.size();
    }

    public String toString() {
        return this.unused.toString();
    }

    void reportUnused() {
        if (this.unused.isEmpty()) {
            return;
        }
        LinkedList<Invocation> invocations = new LinkedList<Invocation>();
        for (Stubbing stubbing : this.unused) {
            invocations.add(stubbing.getInvocation());
        }
        if (invocations.isEmpty()) {
            return;
        }
        Reporter.unncessaryStubbingException(invocations);
    }
}

