/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.asn1.type;

import org.apache.hadoop.shaded.org.apache.kerby.asn1.Tag;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Constructed;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Sequence;
import org.apache.hadoop.shaded.org.apache.kerby.asn1.type.Asn1Set;

public class Asn1Collection
extends Asn1Constructed {
    public Asn1Collection(UniversalTag universalTag) {
        super(new Tag(universalTag));
    }

    public static boolean isCollection(Tag tag) {
        return Asn1Collection.isCollection(tag.universalTag());
    }

    public static boolean isCollection(int tag) {
        return Asn1Collection.isCollection(new Tag(tag));
    }

    public static boolean isCollection(UniversalTag universalTag) {
        switch (universalTag) {
            case SEQUENCE: 
            case SEQUENCE_OF: 
            case SET: 
            case SET_OF: {
                return true;
            }
        }
        return false;
    }

    public static Asn1Collection createCollection(Tag tag) {
        if (!Asn1Collection.isCollection(tag)) {
            throw new IllegalArgumentException("Not collection type, tag: " + tag);
        }
        return Asn1Collection.createCollection(tag.universalTag());
    }

    public static Asn1Collection createCollection(UniversalTag universalTag) {
        if (!Asn1Collection.isCollection(universalTag)) {
            throw new IllegalArgumentException("Not collection type, tag: " + (Object)((Object)universalTag));
        }
        switch (universalTag) {
            case SEQUENCE: {
                return new Asn1Sequence();
            }
            case SEQUENCE_OF: {
                return new Asn1Sequence();
            }
            case SET: {
                return new Asn1Set();
            }
            case SET_OF: {
                return new Asn1Set();
            }
        }
        throw new IllegalArgumentException("Unexpected tag " + universalTag.getValue());
    }
}

