/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Challenge;

public class TextNavigator
implements CharSequence {
    private final CharSequence content;
    private int p1;
    private int p2;
    private boolean reversed;

    public static TextNavigator build(CharSequence content) {
        return new TextNavigator(content, 0, content.length(), false);
    }

    public TextNavigator reverse(int pos) {
        if (this.reversed) {
            throw new IllegalStateException();
        }
        return new TextNavigator(this.content, 0, this.p1 + pos, true);
    }

    @Override
    public String toString() {
        int length = this.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }

    private TextNavigator(CharSequence content, int p1, int p2, boolean reversed) {
        if (p2 < p1) {
            throw new IllegalArgumentException();
        }
        this.content = content;
        this.p1 = p1;
        this.p2 = p2;
        this.reversed = reversed;
    }

    public int indexOf(char ch) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TextNavigator subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length() || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ", " + endIndex + ") out of bounds for length " + this.length());
        }
        if (this.reversed) {
            return new TextNavigator(this.content, this.p2 - endIndex, this.p2 - beginIndex, this.reversed);
        }
        return new TextNavigator(this.content, this.p1 + beginIndex, this.p1 + endIndex, this.reversed);
    }

    @Override
    public int length() {
        return this.p2 - this.p1;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.length());
        }
        if (this.reversed) {
            return this.content.charAt(this.p2 - index - 1);
        }
        return this.content.charAt(this.p1 + index);
    }

    public void jump(int step) {
        if (this.reversed) {
            this.p2 -= step;
        } else {
            this.p1 += step;
        }
    }

    public boolean startsWith(String searched, int ahead) {
        for (int i = 0; i < searched.length(); ++i) {
            if (searched.charAt(i) == this.charAt(ahead + i)) continue;
            return false;
        }
        return true;
    }

    public int search(String searched, int ahead) {
        for (int i = ahead; i < this.length() - searched.length() + 1; ++i) {
            if (!this.startsWith(searched, i)) continue;
            return i;
        }
        return -1;
    }

    public int searchPattern(Challenge pattern, int ahead) {
        for (int i = ahead; i < this.length(); ++i) {
            if (pattern.runChallenge(this, i).getFullCaptureLength() < 0) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }
}

