/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.oned.algs;

import org.eclipse.elk.alg.layered.compaction.oned.CNode;
import org.eclipse.elk.alg.layered.compaction.oned.CompareFuzzy;
import org.eclipse.elk.alg.layered.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.layered.compaction.oned.algs.IConstraintCalculationAlgorithm;

public class QuadraticConstraintCalculation
implements IConstraintCalculationAlgorithm {
    @Override
    public void calculateConstraints(OneDimensionalCompactor compactor) {
        for (CNode cNode : compactor.cGraph.cNodes) {
            cNode.constraints.clear();
        }
        for (CNode cNode1 : compactor.cGraph.cNodes) {
            for (CNode cNode2 : compactor.cGraph.cNodes) {
                if (cNode1 == cNode2 || cNode1.cGroup != null && cNode1.cGroup == cNode2.cGroup) continue;
                double spacing = compactor.direction.isHorizontal() ? compactor.spacingsHandler.getVerticalSpacing(cNode1, cNode2) : compactor.spacingsHandler.getHorizontalSpacing(cNode1, cNode2);
                if (cNode1 == cNode2.parentNode || !(cNode2.hitbox.x > cNode1.hitbox.x) && (cNode1.hitbox.x != cNode2.hitbox.x || !(cNode1.hitbox.width < cNode2.hitbox.width)) || !CompareFuzzy.gt(cNode2.hitbox.y + cNode2.hitbox.height + spacing, cNode1.hitbox.y) || !CompareFuzzy.lt(cNode2.hitbox.y, cNode1.hitbox.y + cNode1.hitbox.height + spacing)) continue;
                cNode1.constraints.add(cNode2);
            }
        }
    }
}

