# Kamilaroi/Euahlayi

## Introduction

The Kamilaroi (also known as Gomeroi) and Euahlayi peoples are Australian Aboriginal cultural groups located in the northern part of New South Wales. They have survived European invasion and loss of much of their country. Their culture and connection to country remains strong, including an extensive cultural astronomy first recorded in the 1860s.

## Description

### Background

This Stellarium Skyculture is the result of a Higher Degree Research project by Robert Fuller at Macquarie University, Sydney, finishing in 2014. Stellarium was chosen as a part of the project for Giving Back of the collected knowledge to the Kamilaroi and Euahlayi communities in the form of a documentary video (Star Stories of the Dreaming) and a student's Study Guide. Clips from the Stellarium were used in the documentary to illustrate certain sky objects.

## Constellations

##### Emu

Gawaargay is the spirit Emu in the Sky, located with its head in the Coal Sack, and its neck and body stretching out through the dust lanes of the Milky Way (Warrambul) past Scorpius. The Euahlayi and the Kamilaroi see it with legs in April and May, when it is female and chasing the males. From June to August it is male and sitting on its nest without legs (the males brood the chicks), and this is a signal to collect the eggs. In the evening in late August it is vertical in the sky, and the head and body form two "eggs", meaning the eggs should not be collected. Later in the year, it appears on the horizon, so it is believed to be sitting in a waterhole, meaning the waterholes are full. When it is below the horizon, then it is on Earth as the Black Emu, which is rarely seen.

##### Birringoloo

Birringoloo is the second wife of Byaame, the creator/culture hero. She sits by the campfire of Byaame's camp (the star Alpha Muscae), and all women with girl children who die come to this camp before going on to Bulimah (Heaven behind Warrambul). They wait at this camp until all their girl children have died and come to the camp, and then they can proceed to Bulimah.

##### Roots

Yarran (also called mingga) is the roots of the Yarran tree, an Acacia, which is the tree that Byaame took up to the Warrambul with the first man to die (and the Cockatoos). It is actually centred on the Coal Sack, and the dark nebula is the hollow of the tree seen from below, with the roots spreading around. When someone dies and goes to Bulimah, they go through the hollow of the Yarran.

##### Clever Man

A Wiringin is a "Clever Man" or Aboriginal doctor. This Wiringin located in the Small Magellanic Cloud is there because he controls who can go on to Bulimah. If the person who died is not initiated, they are not allowed, because they don't know the rules, so he sends them to Wadhaagudjaaylwan in the Large Magellanic Cloud. This birth spirit will send the uninitiated back to Earth as a new baby, so they can be initiated. This Wiringin is represented in every Aboriginal cemetery as the Wilga tree (Native Willow).

##### Uninitiated boys

The Birray Birray are a group of uninitiated boys who are in love with the seven young women (sisters), Miyay Miyay, who make up the Pleiades star cluster. They chased the Miyay Miyay, who ended up in the sky, and for this they were placed in Orion, as the three stars that make up the belt of Orion. Rigel is their fire, and the sword of Orion is their fire poker. They are kept from the Miyay Miyay by the Wiringin, Old Dthillar, who is Aldebaran.

##### Seven sisters

The Miyay Miyay are the seven young women (sisters) who were chased into the sky, depending on the story, by the Birray Birray, or by various Wiringins or other bad persons. They form the Pleiades star cluster, and as one sister is shy, normally we only see six stars. They are protected from the Birray Birray in Orion by the Wiringin, Old Dthillar, who is Aldebaran.

##### Old Dthillar with hut

Old Dthillar is a Wiringin, in this case the Wiringin of the Birray Birray, the unitiated boys in Orion who pine for the Miyaay Miyaay (Seven Sisters) in the Pleiades. Old Dthillar is the star Aldebaran, which is also Alpha Tauri, and he stands there to protect the Miyaay Miyaay from the Birray Birray. The inverted "V" shape made up by Alpha, Epsilon, and Gamma Tauri is Old Dthillar's gunya (hut).

##### Madness

"Wamba" means "crazy" or "mad". In this case, the star Canopus is called Wamba Wamba because of various reasons, depending on whose story is told. The planet Venus is also called Wamba. One speculation is that both Canopus and Venus are seen close to the horizon in the summer, and due to atmospheric defraction, can "scintillate" (twinkle srongly), which results in rapid changes in colour. This might be interpreted as madness.

##### Wadhaagudjaaylwan

Wadhaagudjaaylwan is Byaame's third wife, who is in the Large Magellanic Cloud, and sings to women who are going to have babies. She "sings" the babies to the women on Earth, and she takes the persons that the Old Wiringin in the Small Magellanic Cloud sends to her, and sends them back to Earth as babies.

##### Kangaroo

Bandaarr is Kamilaroi/Euahlayi for Kangaroo, and this kangaroo is located under the belly of the Emu in the Milky Way, looking away from the Emu. Bandaarr is either a grey or red kangaroo, depending on the culture, and has significance in ceremony.

##### Sulfur-crested cockatoo

Muraay is Kamilaroi, and Muyaay is Euahlayi for the sulfur-crested cockatoo, who are the Pointer stars (Alpha Centauri and Hadar/Beta Centauri). They ended up in the constellation Crux when their tree, the Yarran, was dragged into the sky with the first man to die, and they are always chasing Yarran.

##### Warrawilbaarru

Warrawilbaarru is the whirlwind spirit who lives in the constellation Scorpius. Byaame normally keeps him from coming to Earth, but in September he comes out of one of three holes (dark nebulae) in Scorpius during September, and doesn't go back until around March. During this time he is on earth as the "willy willy" or whirlwind, and can be dangerous to children and uninitiated men.

## References

 - [#1]: More detailed information on the astronomy of the Kamilaroi and Euahlayi peoples can be found at [https://unsw.academia.edu/RobertFuller](https://unsw.academia.edu/RobertFuller).

## Authors

Robert S. Fuller and Ghillar Michael Anderson

## License

CC BY-NC-ND 4.0
