dojo
====

This is the foundation package for the Dojo 1 Toolkit.  While still being maintained, new development is primarily focused on modern Dojo.

Checkout the [Dojo framework website](https://dojo.io/) or if you want a more detailed technical status and overview, checkout the [`Dojo roadmap`](https://dojo.io/community/).

This package is sometimes
referred to as the “core”, it contains the most generally applicable sub-packages
and modules. The dojo package covers a wide range of functionality like Ajax, DOM
manipulation, class-type programming, events, promises, data stores,
drag-and-drop and internationalization libraries.

Installing
----------

Installation instructions are available at
[dojotoolkit.org/download](<http://dojotoolkit.org/download/>).

Getting Started
---------------

If you are starting out with Dojo, the following resources are available to you:

-   [Tutorials](<http://dojotoolkit.org/documentation/>)

-   [Reference Guide](<http://dojotoolkit.org/reference-guide/>)

-   [API Documentation](<http://dojotoolkit.org/api/>)

-   [Community Forum](<http://dojotoolkit.org/community/>)

What to Use Dojo For and When to Use It
---------------------------------------

The following is a brief sampling of some of the areas where Dojo may prove to
be the right tool for your next project:

-   For keeping your code fast and maintainable, Dojo offers an asynchronous
    module definition (AMD) loader -- encapsulating pieces of code into useful
    units, loading small JavaScript files only when they are needed, and loading
    files separately even when they are dependent on one another.

-   When you want to easily extend existing classes, share functionality among a
    number of classes, and maximize code reuse, Dojo provides class-like
    inheritance and “mixins.”

-   For creating advanced and customizable user interfaces out of refined,
    efficient, and modular pieces, Dojo’s Dijit framework offers several dozen
    enterprise-ready widgets -- including buttons, textboxes, form widgets with
    built-in validation, layout elements, and much more -- along with themes to
    lend them a consistent look. All of this is available for mobile
    environments as well.

-   For working with advanced vector graphics, Dojo’s GFX API can render
    graphics in a wide variety of formats, with support for seamless
    manipulation (skewing, rotating, resizing), gradients, responding to mouse
    events, and more.

-   The `dojox/charting` library supports powerful data visualization and
    dynamic charting, including a variety of 2D plots and animated charting
    elements.

-   When you need feature-rich, lightweight, and mobile-friendly grids/tables,
    Dojo offers the `dgrid` widget, along with customizable default themes and
    accompanying features such as in-cell editing, row/cell selection, column
    resizing/reordering, keyboard handling, pagination, and more.

-   Dojo is the officially supported framework for the ArcGIS API for
    JavaScript, one of the most widely used enterprise-grade APIs for web
    mapping and spatial analysis -- learning to use Dojo will open doors to
    creating richer web mapping applications using that API.

License and Copyright
---------------------

The Dojo Toolkit (including this package) is dual licensed under BSD 3-Clause
and AFL. For more information on the license please see the [License
Information](<http://dojotoolkit.org/license>). The Dojo Toolkit is Copyright
(c) 2005-2018, JS Foundation. All rights reserved.
